var POSSIBLE_BETS = [1,2,5,10,20,50,100,200,500,1000];

var elems = {}; var game = {};

function Money(money,bet) {
  this.money = Math.floor(money || 0);
  this.bet = Math.floor(bet || 0);
  this.collect = function() {
    this.money += this.bet;
    this.bet = 0;
    this.update();
  };
  this.stake = function(n) {
    if(n > this.money) {
      this.bet += this.money;
      this.money = 0;
    } else {
      this.bet += n;
      this.money -= n;
    }
    this.update();
  };
  this.lose = function() {
    this.bet = 0;
  };
  this.setMoney = function(n) {
    this.money = n;
    this.update();
  };
  this.addMoney = function(n) {
    this.money += n;
    this.update();
  };
  this.setBet = function(n) {
    this.bet = n;
    this.update();
  };
  this.addBet = function(n) {
    this.bet += n;
    this.update();
  };
  this.update = function() {
    saveMoney();
  };
}

var money = new Money(1000,0);

function loadMoney() {
  var cookies = document.cookie.split('; ');
  for(var i = 0; i < cookies.length; i++) {
    var cookie = cookies[i].split('=');
    if(cookie[0] == "money") {
      var n = parseInt(cookie[1]);
      if(n <= 0) return;
      money.setMoney(n);
      return;
    }
  }
  update();
}

function saveMoney() {
  document.cookie = "money="+money.money;
}

function update() {
  if(elems && elems.money) elems.money.textContent = "$"+commaify(money.money);
  if(elems && elems.bet) elems.bet.textContent = "$"+commaify(money.bet);
  if(game && game.phand) game.phand.update();
  if(game && game.dhand) game.dhand.update();
  if(elems && elems.heat) {
    elems.heat.style.color = "black";
    if(!game || !game.heat) {
      elems.heat.textContent = "0";
    } else if(game.heat > 0) {
      elems.heat.textContent = "+"+game.heat;
      if(game.heat > 10) { elems.heat.style.color = "red"; }
    } else {
      elems.heat.textContent = "-"+(-game.heat);
      if(game.heat < -10) { elems.heat.style.color = "blue"; }
    }
  }
}

function commaify(n) {
  var s = ""+n;
  for(var i = s.length-3; i > 0; i -= 3) {
    s = s.substr(0,i)+","+s.substr(i);
  }
  return s;
}

function hand() {
  update();
  elems.next.disabled = "disabled";
  if(!game.deck || game.deck.count() < 52) {
    game = {};
    game.deck = new BJCollection();
    game.deck.fill(8); game.deck.shuffle();
    game.deck.onpop = function(card){if(card.shown)count(card);}
    game.heat = 0;
  }
  game.phand = new BJCollection();
  game.dhand = new BJCollection();
  while(elems.dealer.firstChild) elems.dealer.removeChild(elems.dealer.firstChild);
  while(elems.player.firstChild) elems.player.removeChild(elems.player.firstChild);
  elems.bets.each(function(n) {
      this.onclick = function() {
        money.stake(n);
        elems.bets.each(function(){this.disabled="disabled"});
        deal();
      };
      if(money.money >= n) this.disabled = "";
    });
}

function count(card) {
  if(!game || !card) return;
  if(card.face < 5) game.heat++;
  else if(card.face > 7) game.heat--;
}

function deal() {
  update();
  //Cards get dealt in the correct order. How cool is that?
  for(var i = 0; i < 2; i++) {
    game.phand.push(game.deck.pop(1));
    game.dhand.push(game.deck.pop(i!=0));
  }
  while(elems.dealer.firstChild) elems.dealer.removeChild(elems.dealer.firstChild);
  while(elems.player.firstChild) elems.player.removeChild(elems.player.firstChild);
  elems.dealer.appendChild(game.dhand.render());
  elems.player.appendChild(game.phand.render());
  update();
  var dvalue = game.dhand.value();
  var pvalue = game.phand.value();
  if(dvalue == 21 && pvalue == 21) {
    //Double Blackjack!
    over(); return;
  } else if(pvalue == 21) {
    //Player Blackjack!
    money.addBet(Math.floor(money.bet*3.0/2.0));
    over(); return;
  } else if(dvalue == 21) {
    //Dealer Blackjack!
    money.lose();
    over(); return;
  }
  elems.hit.onclick = function() {
    elems.double.disabled = "disabled";
    elems.surrender.disabled = "disabled";
    game.phand.push(game.deck.pop(1));
    if(game.phand.value() > 21) tally();
    else update();
  };
  elems.stand.onclick = function() {
    dealer();
  };
  elems.double.onclick = function() {
    money.stake(money.bet);
    game.phand.push(game.deck.pop(1));
    dealer();
  };
  elems.surrender.onclick = function() {
    money.addBet(-Math.ceil(money.bet/2.0));
    over();
  };
  elems.hit.disabled = "";
  elems.stand.disabled = "";
  elems.double.disabled = "";
  elems.surrender.disabled = "";
}

function dealer() {
  update();
  while(!game.deck.isEmpty() && (game.dhand.value() < 17 || (game.dhand.value() == 17 && game.dhand.soft()))) {
    game.dhand.push(game.deck.pop(1));
  }
  tally();
}

function tally() {
  var dvalue = game.dhand.value();
  var pvalue = game.phand.value();
  if(dvalue > 21 && pvalue > 21 || dvalue == pvalue) {
    //Double Bust / Same Score
  } else if(pvalue > 21) {
    //Player Bust
    money.lose();
  } else if(dvalue > 21 || pvalue > dvalue) {
    //Dealer Bust / Player Win
    money.addBet(money.bet);
  } else {
    //Dealer Wins
    money.lose();
  }
  over();
}

function over() {
  money.collect();
  elems.hit.disabled = "disabled";
  elems.stand.disabled = "disabled";
  elems.double.disabled = "disabled";
  elems.surrender.disabled = "disabled";
  elems.bets.each(function(){this.disabled="disabled"});
  game.dhand.each(function() {
      if(this.shown) return;
      count(this); this.show();
    });
  update();
  var to = setTimeout(hand,5000);
  elems.next.onclick = function() {
    clearTimeout(to); hand();
  };
  elems.next.disabled = "";
  saveMoney();
}
